//----------------------------------------------------------------------------//
//- CapQuittung.pas ----------------------------------------------------------//
//----------------------------------------------------------------------------//

//- Beschreibung -------------------------------------------------------------//
// Dient zum Ausdrucken von Quittungen                                        //
// -> TCaQrpQuittung ist von TCaQrpBaseReport abgeleitet                      //
//----------------------------------------------------------------------------//

unit CapQuittung;

//------------------------------------------------------------------------------

interface

//------------------------------------------------------------------------------

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, CapBaseReport, QuickRpt, QRCtrls, ExtCtrls, CaoArtikelListe,
  CaoBoersenInfo, CaoFormat;

//------------------------------------------------------------------------------

type
  TCaQrpQuittung = class(TCaQrpBaseReport)
    m_BndTitel                : TQRBand;
    m_QrLblQuittung           : TQRLabel;
    m_BndUeberschrift         : TQRChildBand;
    m_QrLblPos                : TQRLabel;
    m_QrLblArtNummer          : TQRLabel;
    m_QrLblBeschreibung       : TQRLabel;
    m_QrLblPreis              : TQRLabel;
    m_BndArtikel              : TQRStringsBand;
    m_QrLblArtPos             : TQRLabel;
    m_QrLblArtArtikelNummer   : TQRLabel;
    m_QrLblArtBeschreibung    : TQRLabel;
    m_QrLblArtPreis           : TQRLabel;
    m_BndTotal                : TQRStringsBand;
    m_QrLblTotal              : TQRLabel;
    m_QrLblTotalBetrag        : TQRLabel;

    //--------------------------------------------------------------------------

    procedure QuickRepBeforePrint  (Sender         : TCustomQuickRep;
                                    var PrintReport: Boolean);
    procedure BndArtikelBeforePrint(Sender: TQRCustomBand;
                                    var PrintBand  : Boolean);

  //----------------------------------------------------------------------------

  private
    m_obArtikelListe: TCaoArtikelListe;

  //----------------------------------------------------------------------------
  
  public
    procedure Preview(obBoersenInfo : TCaoBoersenInfo;
                      obArtikelListe: TCaoArtikelListe);
    procedure Print  (obBoersenInfo: TCaoBoersenInfo;
                      obArtikelListe: TCaoArtikelListe);

  //----------------------------------------------------------------------------

  end; // TCaQrpQuittung

//------------------------------------------------------------------------------

var
  CaQrpQuittung: TCaQrpQuittung;

//------------------------------------------------------------------------------

implementation

//------------------------------------------------------------------------------

{$R *.dfm}

//------------------------------------------------------------------------------

procedure TCaQrpQuittung.Preview(obBoersenInfo : TCaoBoersenInfo;
                                 obArtikelListe: TCaoArtikelListe);
begin
  m_obArtikelListe := obArtikelListe;
  inherited Preview(obBoersenInfo);
end; // TCaQrpQuittung.Preview

//------------------------------------------------------------------------------

procedure TCaQrpQuittung.Print(obBoersenInfo : TCaoBoersenInfo;
                               obArtikelListe: TCaoArtikelListe);
begin
  m_obArtikelListe := obArtikelListe;
  inherited Print(obBoersenInfo);
end; // TCaQrpQuittung.Print

//------------------------------------------------------------------------------

procedure TCaQrpQuittung.QuickRepBeforePrint(Sender         : TCustomQuickRep;
                                             var PrintReport: Boolean);
var
  iIndex: Integer;
begin
  inherited;
  m_BndArtikel.Items.Clear;
  // Erzeugen der Bnder mit den Artikeldaten
  for iIndex := 0 to m_obArtikelListe.Count -1 do begin
    m_BndArtikel.Items.Add(IntToStr(iIndex));
  end; // for
  // Abfllen des Totals
  m_QrLblTotalBetrag.Caption := m_obFormat.FormatCurrency
                                                      (m_obArtikelListe.dTotal);
end; // TCaQrpQuittung.QuickRepBeforePrint

//------------------------------------------------------------------------------

procedure TCaQrpQuittung.BndArtikelBeforePrint(Sender       : TQRCustomBand;
                                               var PrintBand: Boolean);
begin
  inherited;
  m_QrLblArtPos.Caption           := IntToStr(StrToInt(m_BndArtikel.Item) + 1);
  m_QrLblArtArtikelNummer.Caption := m_obFormat.FormatBarCode
    (m_obArtikelListe.Items[StrToInt(m_BndArtikel.Item)].iArtikelNummer);
  m_QrLblArtBeschreibung.Caption  :=
    m_obArtikelListe.Items[StrToInt(m_BndArtikel.Item)].sBeschreibung;
  m_QrLblArtPreis.Caption := m_obFormat.FormatCurrency
    (m_obArtikelListe.Items[StrToInt(m_BndArtikel.Item)].dPreis);
end; // TCaQrpQuittung.BndArtikelBeforePrint

//------------------------------------------------------------------------------

end. // CapQuittung
